<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="shortcut icon" href="assets/images/favicon-goat-digital.png" type="image/x-icon">
    <title>Formulário de Chat Dinâmico</title>
    <!-- Adicionando FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="assets/css/index.css">
</head>

<body>
    <div class="chat-container">
        <!-- Header do Chat -->
        <div class="chat-header">
            <img src="assets/images/foto-perfil-murilo-goat-digital.png" alt="Logo da Empresa">
            <h2>Murilo - GOAT Digital</h2>
        </div>

        <!-- Área de Mensagens -->
        <div class="chat-box" id="chat-box">
            <div class="chat-message bot">Olá! Qual é o seu nome?</div>
        </div>
    </div>

    <!-- Formulário Fixo na Parte Inferior -->
    <form action="send_email.php" method="post" id="chat-form" class="chat-form">
        <div class="input-container">
            <input type="text" id="name" name="name" placeholder="Digite seu nome" required class="visible">
            <button type="button" class="send-button" id="send-name"><i class="fas fa-arrow-right"></i></button>
        </div>
        <div class="input-container hidden">
            <input type="text" id="company" name="company" placeholder="Digite o nome da sua empresa" required>
            <button type="button" class="send-button" id="send-company"><i class="fas fa-arrow-right"></i></button>
        </div>
        <div class="input-container hidden">
            <select id="employees" name="employees" required class="styled-select">
                <option value="" disabled selected>Selecione o número de funcionários</option>
                <option value="1 a 15">1 a 15</option>
                <option value="15 a 50">15 a 50</option>
                <option value="50 a 100">50 a 100</option>
                <option value="Mais de 100">Mais de 100</option>
            </select>
            <button type="button" class="send-button" id="send-employees"><i class="fas fa-arrow-right"></i></button>
        </div>
        <div class="input-container hidden">
            <input type="tel" id="phone" name="phone" placeholder="Digite seu telefone" required>
            <button type="button" class="send-button" id="send-phone"><i class="fas fa-arrow-right"></i></button>
        </div>
        <div class="error-message" id="phone-error">Telefone inválido. Por favor, digite um telefone válido com DDD.</div>
        <div class="input-container hidden">
            <textarea id="message" name="message" placeholder="Digite sua mensagem" required></textarea>
            <button type="button" class="send-button" id="send-message"><i class="fas fa-arrow-right"></i></button>
        </div>
    </form>

    <script src="assets/js/index.js"></script>
</body>

</html>